/* Copyright (c) 2016-2018 VMware, Inc. All rights reserved. */
package com.vmware.automatic.plugin.registration.commands;

import com.vmware.vim25.RuntimeFaultFaultMsg;

/**
 * Parsing and prepare command line arguments to operation is plugin registered plugin.
 * <p>
 * ./extension-registration -action isPluginRegistered
 * -url <https://IP_OF_THE_VCENTER/sdk/> - required argument, vCenter server IP
 * -username <USERNAME>                  - required argument, vCenter server username
 * -password <PASSWORD>                  - required argument, vCenter server password
 * -key <MY_PLUGIN_KEY>                  - required argument, plugin key
 */
public class IsPluginRegisteredCmd extends PluginCmd {

   public IsPluginRegisteredCmd(){
      _action = "-action isPluginRegistered";
      _errorMessage = "Check if plugin is registered to the VC";
   }
   /**
    * Check if plugin is registered
    */
   protected void doExecute() {
      if (_key == null) {
         System.out.println("To verify that a plugin is registered you must provide the key for the plugin\n");
      } else {
         try {
            if (_vimPort.findExtension(_extensionManager, _key) != null) {
               System.out.println("Plugin: " + _key + " is registered.");
            } else {
               System.out.println("Plugin: " + _key + " is not registered.");
            }
         } catch (RuntimeFaultFaultMsg e) {
            System.out.println("Exception while finding plugin");
            e.printStackTrace();
         }
      }
   }
}
